<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Dtos\Admin;

use Erlage\Photogram\Data\Dtos\AbstractDTO;
use Erlage\Photogram\Data\Dtos\Traits\TraitComplaintValidatorDTO;
use Erlage\Photogram\Data\Dtos\Traits\TraitComplaintTransformerDTO;

class AdminTableStatsDTO extends AbstractDTO
{
    /**
     * to comply with DTO interface
     */
    use TraitComplaintValidatorDTO;
    use TraitComplaintTransformerDTO;

    const DTO_NAME = 'admin_table_stats_dto';

    /*
    |--------------------------------------------------------------------------
    | key map
    |--------------------------------------------------------------------------
    */

    const KEY_TABLE_NAME = 'table_name';

    const KEY_TOTAL_ROWS = 'total_rows';

    const KEY_PREVIOUS_SIX_MONTH_STATS = 'previous_six_month_stats';

    const KEY_PERCENTAGE_FROM_LAST_MONTH = 'percentage_from_last_month';

    /*
    |--------------------------------------------------------------------------
    | data
    |--------------------------------------------------------------------------
    */

    /**
     * @var string
     */
    private $tableName;

    /**
     * @var string
     */
    private $totalRows;

    /**
     * @var string
     */
    private $previousSixMonthStats;

    /**
     * @var string
     */
    private $percentagFromLastMonth;

    /*
    |--------------------------------------------------------------------------
    | setters
    |--------------------------------------------------------------------------
    */

    /**
     * @return static 
     */
    public function setTableName(string $tableName)
    {
        $this -> tableName = $tableName;

        return $this;
    }

    /**
     * @return static 
     */
    public function setTotalRows(string $totalRows)
    {
        $this -> totalRows = $totalRows;

        return $this;
    }

    /**
     * @return static 
     */
    public function setPreviousSixMonthStats(array $previousSixMonthStats)
    {
        $this -> previousSixMonthStats = $previousSixMonthStats;

        return $this;
    }

    /**
     * @return static 
     */
    public function setPercentagFromLastMonth(string $percentagFromLastMonth)
    {
        $this -> percentagFromLastMonth = $percentagFromLastMonth;

        return $this;
    }

    /*
    |--------------------------------------------------------------------------
    | from json
    |--------------------------------------------------------------------------
    */

    /**
     * @return static 
     */
    public static function fromJsonMap(array $data)
    {
        return (new static())
            -> setTableName((string) $data[self::KEY_TABLE_NAME])
            -> setTotalRows((string) $data[self::KEY_TOTAL_ROWS])
            -> setPreviousSixMonthStats((array) $data[self::KEY_PREVIOUS_SIX_MONTH_STATS])
            -> setPercentagFromLastMonth((string) $data[self::KEY_PERCENTAGE_FROM_LAST_MONTH]);
    }

    /*
    |--------------------------------------------------------------------------
    | serialization for json_encode
    |--------------------------------------------------------------------------
    */

    public function jsonSerialize()
    {
        return array(
            self::KEY_TABLE_NAME                 => $this -> tableName,
            self::KEY_TOTAL_ROWS                 => $this -> totalRows,
            self::KEY_PREVIOUS_SIX_MONTH_STATS   => $this -> previousSixMonthStats,
            self::KEY_PERCENTAGE_FROM_LAST_MONTH => $this -> percentagFromLastMonth,
        );
    }

    /*
    |--------------------------------------------------------------------------
    | implement DTO methods
    |--------------------------------------------------------------------------
    */

    /**
     * @param AdminTableStatsDTO $adminSettingSaveResultsDTO
     */
    public static function serialize($adminSettingSaveResultsDTO): string
    {
        return \json_encode($adminSettingSaveResultsDTO);
    }

    /**
     * @return AdminTableStatsDTO
     */
    public static function deSerialize(string $adminSettingSaveResultsDTO)
    {
        $data = \json_decode($adminSettingSaveResultsDTO, true);

        return static::fromJsonMap($data);
    }
}
